#pragma once
#include "service.h"
#include "ConfigDATA.h"
#include "ServiceDataLink.h"
#include "ConfigGPRS.h"
#include "ConfigCFG.h"
////////////////////////////////////////////////////////////////////////////

#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport) 
#endif
////////////////////////////////////////////////////////////////////////////
class CDataLink;
class DLLMANAGER_API CServiceDATA : public CService
{
protected:
	UInt8		mPlusCount;
	UInt8		mDataModeChannel;
	//CDataLink*	mDataLinkP;

protected:
	virtual void PrvParseParam99(CString iStrParam, CString* oHost, CString* oPort, CString* oProto, CString* l2p, CString* oCid);
	virtual void PrvParseParam98(CString iStrParam, CString* oHost, CString* oPort, CString* oProto, CString* l2p, CString* oCid);
	virtual CString PrvExtractParamSet(CString* ioStrToParse);
	virtual CString PrvExtractParamFromSet(CString* ioStrToParse);

	virtual Bool CServiceDATA::FindPlusPlusPlus(CDataMessage* iData);	
	virtual Bool PrvConnect(int iChannel, CString iHost, CString iPort, CString iProto);
	virtual Bool PrvFindPDP(CString iCid, CGPRSContext* ioPDP);
	virtual void PrvCloseAllLine();

public:
	CServiceDATA(void);
	CServiceDATA(CDllManager* iDllManager);
	virtual ~CServiceDATA(void);
	virtual Bool Dispatch(CCmd* iCmdP);
	virtual Bool ProcessData(CDataMessage* iData);
	virtual void OnConfigChange(int iConfigID);

	virtual Bool D99(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool D98(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool PlusPlusPlus(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool D(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool pppATH(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CHARGEN(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGDATA(CCmd* iCmdP, Bool iSilentMode=0);	
	
	virtual Bool CSDCall(CCmd* iCmdP, Bool iSilentMode=0);	
};
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////